(defun c:dxf2mif (/ plines_f plines_d regions_f regions_d pontos_f pontos_d linhas_f linhas_d
   tudo n_objs i nome objeto cota cota_ini cota_fim identificador camada tipo texto n_pares j)
;;
;; atualizado em 13 de junho de 2021 (Marcelo E. Giacaglia)
;;
;; importante:
;; - ajustar o LIMITS para englobar a area de interesse antes de executar (precisao das coordenadas)
;;
;; tudo - lista de objetos
;; n_objs - numero de objetos da lista de objetos
;;
;; filepath - caminho do dwg aberto
;; plines_d - arquivo .mid de polylines
;; regions_d  - arquivo .mid de poligonos
;; pontos_d - arquivo .mid de pontos e textos
;; linhas_d - arquivo .mid de lines
;;
;; plines_f - arquivo .mif de polylines
;; regions_f  - arquivo .mif de poligonos
;; pontos_f - arquivo .mif de pontos e textos
;; linhas_f - arquivo .mif de lines
;;
;; i - contador
;; nome - nome de um objeto da lista de objetos
;; objeto - lista de par-valor de um objeto
;; identificador - handle de um objeto 
;; camada - layer de um objeto
;; tipo - tipo de um objeto
;; texto - texto de um objeto do tipo texto
;; texto_h - horizontal text justification - codigo dxf de (x,y,z) depende de texto_h e texto_v
;; texto_v - vertical text justification
;; n_pares - tamanho da lista de um objeto
;; par - par atributo valor da lista de um objeto
;; j, k - contadores
;;
;; abre e gera cabealhos dos arquivos MIF
;;
(setq filepath (getvar "dwgprefix"))
(setq plines_f (open (strcat filepath "plines.mif") "w") regions_f (open (strcat filepath "regions.mif") "w") pontos_f (open (strcat filepath "pontos.mif") "w") linhas_f (open (strcat filepath "linhas.mif") "w"))
;; pontos e textos
(write-line "VERSION 300" pontos_f)
(princ "Charset " pontos_f) (prin1 "WindowsLatin1" pontos_f) (write-line "" pontos_f)
(princ "DELIMITER " pontos_f) (prin1 ";" pontos_f) (write-line "" pontos_f)
(write-line "COLUMNS 4" pontos_f)
(write-line "handle char(8)" pontos_f)
(write-line "camada char(64)" pontos_f)
(write-line "cota decimal(8,2)" pontos_f)
(write-line "valor char(255)" pontos_f)
(write-line "DATA" pontos_f)
;; linhas
(write-line "VERSION 300" linhas_f)
(princ "Charset " linhas_f) (prin1 "WindowsLatin1" linhas_f) (write-line "" linhas_f)
(princ "DELIMITER " linhas_f) (prin1 ";" linhas_f) (write-line "" linhas_f)
(write-line "COLUMNS 4" linhas_f)
(write-line "handle char(8)" linhas_f)
(write-line "camada char(64)" linhas_f)
(write-line "cota_ini decimal(8,2)" linhas_f)
(write-line "cota_fim decimal(8,2)" linhas_f)
(write-line "DATA" linhas_f)
;; polylines
(write-line "VERSION 300" plines_f)
(princ "Charset " plines_f) (prin1 "WindowsLatin1" plines_f) (write-line "" plines_f)
(princ "DELIMITER " plines_f) (prin1 ";" plines_f) (write-line "" plines_f)
(write-line "COLUMNS 5" plines_f)
(write-line "handle char(8)" plines_f)
(write-line "camada char(64)" plines_f)
(write-line "cota decimal(8,2)" plines_f)
(write-line "DATA" plines_f)
;; poligonos
(write-line "VERSION 300" regions_f)
(princ "Charset " regions_f) (prin1 "WindowsLatin1" regions_f) (write-line "" regions_f)
(princ "DELIMITER " regions_f) (prin1 ";" regions_f) (write-line "" regions_f)
(write-line "COLUMNS 3" regions_f)
(write-line "handle char(8)" regions_f)
(write-line "camada char(64)" regions_f)
(write-line "cota decimal(8,2)" regions_f)
(write-line "DATA" regions_f)
;;
;; abre arquivos MID
;;
(setq plines_d (open (strcat filepath "plines.mid") "w") regions_d (open (strcat filepath "regions.mid") "w") pontos_d (open (strcat filepath "pontos.mid") "w") linhas_d (open (strcat filepath "linhas.mid") "w"))
;;
;; coleta os dados
;;
(setq tudo (ssget "X") n_objs (sslength tudo) i 0)
(repeat n_objs
   (setq nome (ssname tudo i)
              objeto (entget nome)
               identificador (cdr (assoc 5 objeto))
               camada (cdr (assoc 8 objeto))
               tipo (cdr (assoc 0 objeto))
    )
   (cond 
      (
         (equal tipo "POINT")
            (progn 
               ;; mif
               (setq ponto (cdr (assoc 10 objeto)))
               (princ "POINT " pontos_f)
               (princ (rtos (car ponto) 2 2) pontos_f) (princ " " pontos_f) (princ (rtos (cadr ponto) 2 2) pontos_f) (write-line "" pontos_f)
               ;; cota
               (setq cota (rtos (caddr ponto) 2 2))
               ;; mid
               (prin1 identificador pontos_d) (princ ";" pontos_d)
               (prin1 camada pontos_d) (princ ";" pontos_d)
               (princ cota pontos_d) (princ ";" pontos_d)
               (prin1 "" pontos_d) (write-line "" pontos_d)
            )
         )
      (
         (equal tipo "TEXT")
            (progn 
               ;; mif
               (setq texto_h (cdr (assoc 72 objeto)))
               (setq texto_v (cdr (assoc 73 objeto)))
               (if (and  (= texto_h 0) (= texto_v 0)) 
                   (setq ponto (cdr (assoc 10 objeto)))
                   (setq ponto (cdr (assoc 11 objeto)))
               )
               (princ "POINT " pontos_f)
               (princ (rtos (car ponto) 2 2) pontos_f) (princ " " pontos_f) (princ (rtos (cadr ponto) 2 2) pontos_f) (write-line "" pontos_f)
               ;; cota
               (setq cota (rtos (caddr ponto) 2 2))
               ;; mid
               (prin1 identificador pontos_d) (princ ";" pontos_d)
               (prin1 camada pontos_d) (princ ";" pontos_d) 
               (princ cota pontos_d) (princ ";" pontos_d)
               (setq texto (cdr (assoc 1 objeto)))
               (prin1 texto pontos_d)(write-line "" pontos_d)
            )
         )
      (
         (equal tipo "LINE")
            (progn 
               ;; mif
               (setq ponto (cdr (assoc 10 objeto)))
               (princ "LINE " linhas_f)
               (princ (rtos (car ponto) 2 2) linhas_f) (princ " " linhas_f) (princ (rtos (cadr ponto) 2 2) linhas_f) (princ " " linhas_f)
               ;; cota_ini
               (setq cota_ini (rtos (caddr ponto) 2 2))
               ;; ... mif
               (setq ponto (cdr (assoc 11 objeto)))
               (princ (rtos (car ponto) 2 2) linhas_f) (princ " " linhas_f) (princ (rtos (cadr ponto) 2 2) linhas_f) (write-line "" linhas_f)
               ;; cota_fim
               (setq cota_fim (rtos (caddr ponto) 2 2))          
               ;; mid
               (prin1 identificador linhas_d) (princ ";" linhas_d)
               (prin1 camada linhas_d) (princ ";" linhas_d)
               (princ cota_ini linhas_d) (princ ";" linhas_d)
               (princ cota_fim linhas_d) (write-line "" linhas_d)
            )
         )
      (
         (equal tipo "LWPOLYLINE")
            (progn 
               (setq tipo (cdr (assoc 70 objeto)))
               ;; reduz tipos para default ou closed - descarta 3d e mesh
               (if (> tipo 127) (setq tipo (- tipo 128)) )
               (if (> tipo 7) (setq tipo -1))
               (if (> tipo 3) (setq tipo (- tipo 4)))
               (if (> tipo 1) (setq tipo (- tipo 2)))
               ;;
               (if (equal tipo 1) 
                  ;;
                  ;; poligono
                  ;;
                  (progn
                     (setq cota (rtos (cdr (assoc 38 objeto)) 2 2))
                     ;; mif
                     (write-line "REGION 1" regions_f) 
                     (setq n_pares (length objeto) j 0 k 0)
                     ;;
                     ;; conta vertices do poligono
                     ;;
                     (repeat n_pares
                        (setq par (nth j objeto))
                        (if (equal (car par) 10)
			    (setq k (1+ k))
			)
                        (setq j (1+ j) )
                     )
                     (princ k regions_f) (write-line "" regions_f)
                     ;;
                     ;; grava vertices
                     ;;
                     (setq j 0 k 0)
                     (repeat n_pares
                        (setq par (nth j objeto))
                        (if (equal (car par) 10)
                           (progn
                              (princ (rtos (cadr par) 2 2) regions_f) (princ " " regions_f) (princ (rtos (caddr par) 2 2) regions_f) (write-line "" regions_f)
                           )
			)  
                        (setq j (1+ j))
                     )   
                     ;; mid
                     (prin1 identificador regions_d) (princ ";" regions_d)
                     (prin1 camada regions_d) (princ ";" regions_d)
                     (princ cota regions_d) (write-line "" regions_d)
                  )
               )
               (if (equal tipo 0)  
                  ;;
                  ;; polyline
                  ;;
                  (progn
                     (setq cota (rtos (cdr (assoc 38 objeto)) 2 2))
                     ;; mif
                     (setq n_pares (length objeto) j 0 k 0)
                     ;;
                     ;; conta vertices da polyline
                     ;;
                     (repeat n_pares
                        (setq par (nth j objeto))
                        (if (equal (car par) 10)
                            (setq k (1+ k))
                         )
                        (setq j (1+ j) )
                     )
                     (princ "PLINE " plines_f) (princ k plines_f) (write-line "" plines_f)
                     ;;
                     ;; grava vertices
                     ;;
                     (setq j 0 k 0)
                     (repeat n_pares
                        (setq par (nth j objeto))
                        (if (equal (car par) 10)
                           (progn
                              (princ (rtos (cadr par) 2 2) plines_f) (princ " " plines_f) (princ (rtos (caddr par) 2 2) plines_f) (write-line "" plines_f)
                              )
                         )  
                        (setq j (1+ j))
                     )   
                     ;; mid
                     (prin1 identificador plines_d) (princ ";" plines_d)
                     (prin1 camada plines_d) (princ ";" plines_d)
                     (princ cota plines_d) (write-line "" plines_d)
                  )
               )   
      ))
   ) 
   (setq i (1+ i))
)
(close pontos_d) (close linhas_d) (close plines_d) (close regions_d)
(close pontos_f) (close linhas_f) (close plines_f) (close regions_f)
;;
;;
;; fim do programa
;;
(princ)
)